// Name: Standard Actions for models 350, 600, 650, 950
// Description: Provides built-in actions like "shutdown", "next page" etc
// Author: kartu
//
// History:
//	2010-06-27 kartu - Adapted for 300 from former KeyBindings addon
//	2010-11-28 kartu - 600: Implemented #31 "Use Volume buttons to move through history"
//				300: Fixed "next/prev" page actions consuming "goto page" key events
//	2010-02-05 kartu - Changed direct function calls with "bubbles" for x50
//	2011-02-10 kartu - Implemented # goto TOC, doOption, doSearch, doRotate, doMenu, doSize, doRoot actions
//	2011-02-27 kartu - x50: Added rotate by 0 / 90 / 180 / 270 / clock wise / counter clock wize actions
//	2011-02-27 kartu - 600: Added rotate by 90 action
//	2011-10-27 Mark Nord - Added doPowerSwitch = Sleepmode
//  2011-10-30 Ben Chenoweth - Added goZoomPage
//	2012-02-06 Ben Chenoweth - Added No Action, Goto various nodes, Delete Current Item, Play/Pause Audio
//	2012-02-20 quisvir - Added Action Launcher; code cleaning
//	2012-02-23 Ben Chenoweth - Added Toggle Notes Toolbar

tmp = function() {
	var L, LA, log, NAME, StandardActions, model, book, doHistory, isBookEnabled, addBubbleActions, addOptionalActions,
		doBubble, doBubbleFunc, actionLauncher, actionLauncherConstruct, kbActions;
		
	NAME = "StandardActions";
	L = Core.lang.getLocalizer(NAME);
	LA = Core.lang.getLocalizer("ANALOGUS");	//localisation Analogus
	log = Core.log.getLogger(NAME);

	// Shortcuts
	model = kbook.model;
	book = model.container.sandbox.PAGE_GROUP.findContent('PAGE');
	
	isBookEnabled = function() {
		return book.isEnabled();
	};
	
	// Generic "bubbling" code, bubbles using currently focused item;
	doBubble = function(cmd, param) {
		var currentNode, focus;
		currentNode = model.currentNode;
		if (currentNode) {
			focus = model.container.getWindow().focus;
			if (focus) {
				try {
					focus.bubble(cmd, param);
				} catch (e) {
					log.error("in doBubble, command " + cmd, e);
				}
			} else {
				model.doBlink();
			}
		}
	};
	
	doBubbleFunc = function() {
		doBubble(this.bubble);
	};
	
	// Adds "bubblable" actions, if model supports them
	addBubbleActions = function (actions) {
		var bubbles, bubble, icons, i, m, n;
		bubbles = ["doOption", "doSearch", "doRotate", "doMenu", "doSize"    , "doRoot"   ];
		icons   = ["EMPTY"   , "SEARCH"  , "EMPTY"   , "BACK" ,  "TEXT_SCALE", "ROOT_MENU"];
		for (i = 0, n = bubbles.length; i < n; i ++) {
			bubble = bubbles[i];
			if (model[bubble]) {
				actions.push( {
					name: "BubbleAction_" + bubble,
					title: L("ACTION_" + bubble),
					group: "Book",
					icon: icons[i],
					bubble: bubble,
					action: doBubbleFunc
				});
			}
		}
		bubbles = undefined;
		
		// doRotate for x50
		if (model.onEnterOrientation) {
			var rotateFuncX50 = function() {
				var orientation = model.container.getVariable("ORIENTATION");
				if (this.closeCurrentOverlay) {
					this.closeCurrentOverlay();
				}
				switch (this.bubble) {
					case 0:
					case 1:
					case 2:
					case 3:
						if (orientation === this.bubble) {
							orientation = 0;
						} else {
							orientation = this.bubble;
						}
						break;
					case -1:
						// clock wise
						orientation -= 1;
						if (orientation < 0) {
							orientation = 3;
						}
						break;
					case -2:
						// counter clock wise
						orientation += 1;
						if (orientation > 3) {
							orientation = 0;
						}
						break;
				}
				doBubble("doRotate", orientation);
			};
			
			// FIXME model sniffing, there must be a better way
			// On 600 only rotate by 90 is possible
			if (Core.config.model === "600") {
				m = 1;
				n = 2;
			} else {
				m = -2;
				n = 4;
			}
			
			for (i = m; i < n; i++) {
				if (i >= 0) {
					bubble = "doRotate" + 90 * i;
				} else if (i === -2) {
					bubble = "doRotateCCWise";
				} else {
					bubble = "doRotateCWise";
				}
				actions.push( {
					name: "BubbleAction_" + bubble,
					title: L("ACTION_" + bubble),
					group: "Other",
					bubble: i, 
					action: rotateFuncX50
				});
			}
		}
	};
	
	// Cross-model do history
	//	whereTo - integer, positive moves back
	doHistory = function (whereTo) {
		try {
			if (model.currentBook && model.currentBook.media) {
				if (model.currentBook.media.rememberBy(kbook.bookData, whereTo)) {
					return;
				}
			}		
		} catch (e) {
			log.error("doHistory", e);
		}
		model.doBlink();
	};
	
	addOptionalActions = function(actions) {
		if (Core.config.compat.hasVolumeButtons) {
			actions.push({
				name: "NextSong",
				title: L("ACTION_NEXT_SONG"),
				group: "Other",
				icon: "NEXT_SONG",
				action: function () {
					model.doGotoNextSong();
				}
			},
			{
				name: "PreviousSong",
				title: L("ACTION_PREVIOUS_SONG"),
				group: "Other",
				icon: "PREVIOUS_SONG",
				action: function () {
					model.doGotoPreviousSong();
				}
			},
			{
				name: "GotoAudioNode",
				title: L("ACTION_MUSIC_NODE"),
				group: "Other",
				icon: "AUDIO",
				action: function () {
					var node = kbook.music ? kbook.music : kbook.root.getMusicNode();
					model.currentNode.gotoNode(node, model);
				}
			},
			{
				name: "PausePlayAudio",
				title: L("ACTION_PAUSE_PLAY_AUDIO"),
				group: "Other",
				icon: "PAUSE",
				action: function () {
					// code adapted from x50's songGroup.xml (function "doControl")
					var container, sandbox, SONG;
					try {
						container = model.container;
						sandbox = container.sandbox;
						SONG = kbook.movieData.mp;
						if (SONG.isPlaying()) {
								SONG.stop();
								if (container.getVariable('STANDBY_STATE')) {
									sandbox.control = 0;
								}
						} else {
							if (!container.getVariable('STANDBY_STATE')) {
								// if no current song paused
								model.setVariable('CONTROL', 0);
								return;
							}
							// current song paused
							if (SONG.getDuration() <= SONG.getTime()) {
								// current song at end, so try to go to next song
								if (!model.doGotoNextSong(kbook.movieData, true)) {
									// return to first song and stop
									model.doGotoFirstSong();
									SONG.stop();
									sandbox.control = 0;
									model.setVariable('CONTROL', 0);
									return;
								}
							}
							if (!container.getVariable('FIRST_SONG_STOP_FLAG')) {
								// continue current song
								SONG.start();
								sandbox.control = 1;
							} else {
								// no idea!
								container.setVariable('FIRST_SONG_STOP_FLAG', false);
								sandbox.control = 0;
							}
						}
						// update Audio overlay
						sandbox.volumeVisibilityChanged();
					} catch(e) {
						log.error("Error in StandardActions_x50 trying to pause/play audio", e);
					}
				}
			});
		}
		if (Core.config.model !== "600") {
			actions.push({
				name: "GotoPeriodicalsNode",
				title: L("ACTION_PERIODICALS_NODE"),
				group: "Other",
				icon: "PERIODICALS",
				action: function () {
					model.currentNode.gotoNode(kbook.root.getPeriodicalListNode(), model);
				}
			});
		}
	};
	
	// Action Launcher
	actionLauncher = null;
	
	actionLauncherConstruct = function () {
		var optionDef, parent;
		optionDef = {
			name: 'tempOption',
			title: L('ACTION_LAUNCHER'),
			defaultValue: 'default',
			values: kbActions[0], 
			valueTitles: kbActions[1],
			valueIcons: kbActions[2],
			valueGroups: kbActions[3],
			useIcons: true
		};
		parent = this.parent = model.currentNode;
		if (!parent.nodes) parent.nodes = [];
		Core.addonByName.PRSPSettings.createSingleSetting(parent, optionDef, StandardActions);
		this.nodes = parent.nodes.pop().nodes;
	}
	
	StandardActions = {
		name: NAME,
		title:  LA('ACTION_LAUNCHER'), 
		icon: "LAUNCHER",  //settings
		optionDefs: [],
		onInit: function () {
			kbActions = Core.addonByName.KeyBindings.getActionDefs();
		},
		onSettingsChanged: function (propertyName, oldValue, newValue, object) {
			// Action Launcher
			if (propertyName === 'tempOption') {
				var actionName2action, parent;
				actionName2action = kbActions[4];
				parent = model.currentNode.parent;
				parent.redirect = true;
				parent.parent.enter(model);
				try {
					actionName2action[newValue].action();
				} catch(ignore) {}
			}
		},
		getAddonNode: function () {
			if (actionLauncher === null) {
				actionLauncher = Core.ui.createContainerNode({
					title: LA('ACTION_LAUNCHER'),		//verweist auf den namen in 
					shortName: LA('ACTION_LAUNCHER_SHORT'),
					icon: 'LAUNCHER',
					construct: actionLauncherConstruct
				});
			}
			return actionLauncher;
		},
		// FIXME: check if more actions could be "bublized" 
		actions: [
		//Analogus:
						//Saves/restores system cache
						{
							name: "saveSystemCache",
							title: LA("CACHE_SAVE"),
							group: "SAVE_RESTORE",
							icon: "INTERNAL_MEM",
							action: function () 
							{
								Core.shell.exec('cp -f /Data/database/cache/*  /Data/database/system/PRSPlus/cachesave');
								Core.ui.showMsg(LA("MSG_CACHE_SAVE"));
							}
						},	

						{
							name: "restoreSystemCache",
							title: LA("CACHE_RESTORE"),
							group: "SAVE_RESTORE",
							icon: "BACK",
							action: function () 
							{
								Core.shell.exec('cp -f /Data/database/system/PRSPlus/cachesave/* /Data/database/cache');
								Core.ui.showMsg(LA("MSG_CACHE_RESTORE"));
							}
						},						
						//Saving/Restoring PRS-Options:
						{
							name: "SavePRS1",
							title: LA("ACTION_SAVE_PRS1"),
							group: "SAVE_RESTORE",
							icon: "INTERNAL_MEM",
							action: function () 
							{
								Core.shell.exec('cp -R -f /opt0/prsp /Data/database/system/PRSPlus/PRSave1');
								Core.ui.showMsg(LA("MSG_SAVE_PRS"));
							}
						},
						{
							name: "SavePRS2",
							title: LA("ACTION_SAVE_PRS2"),
							group: "SAVE_RESTORE",
							icon: "INTERNAL_MEM",
							action: function () 
							{
								Core.shell.exec('cp -R -f /opt0/prsp /Data/database/system/PRSPlus/PRSave2');
								Core.ui.showMsg(LA("MSG_SAVE_PRS"));
							}
						},
						{
							name: "RestorePRS1",
							title: LA("ACTION_RESTORE_PRS1"),
							group: "SAVE_RESTORE",
							icon: "INTERNAL_MEM",
							action: function () 
							{
								Core.shell.exec('cp -R -f /Data/database/system/PRSPlus/PRSave1/prsp /opt0');
								Core.ui.showMsg(LA("MSG_RESTART_AUTO"));
								kbook.bookData.setData(null);		//dirty workaround
								model.doDeviceShutdown();			//for automatic reboot
							}
						},
						{
							name: "RestorePRS2",
							title: LA("ACTION_RESTORE_PRS2"),
							group: "SAVE_RESTORE",
							icon: "INTERNAL_MEM",
							action: function () 
							{
								Core.shell.exec('cp -R -f /Data/database/system/PRSPlus/PRSave2/prsp /opt0');
								Core.ui.showMsg(LA("MSG_RESTART_AUTO"));
								kbook.bookData.setData(null);
								model.doDeviceShutdown();
							}
						},
						//Resets PRS:
						{
							name: "ResetPRS",
							title: LA("ACTION_RESET_PRS"),
							group: "SAVE_RESTORE",
							icon: "BACK",
							action: function () 
							{ 
								Core.shell.exec('cp -R -f /opt0/prsp /Data/database/system/PRSPlus/PRSave3');
								Core.shell.exec('rm -R /opt0/prsp');
								Core.ui.showMsg(LA("MSG_RESTART_AUTO")); 
								kbook.bookData.setData(null);								
								model.doDeviceShutdown();
							}
							
						},
						//Loads/unloads system-fonts:
						{
							name: "SystemFont1",
							title: LA("ACTION_SYSTEM_FONT_1"),
							group: "SYSTEM_FONTS",
							icon: "FONT",
							action: function () 
							{
								Core.shell.exec('cp -f /Data/fonts/SysFont1/prsp.sh /Data/database/system/PRSPlus/prsp.sh');
								kbook.bookData.setData(null); 
								Core.ui.showMsg(LA("MSG_RESTART_AUTO"));  
								model.doDeviceShutdown();
							}
						},
						{
							name: "SystemFont2",
							title: LA("ACTION_SYSTEM_FONT_2"),
							group: "SYSTEM_FONTS",
							icon: "FONT",
							action: function () 
							{
								Core.shell.exec('cp -f /Data/fonts/SysFont2/prsp.sh /Data/database/system/PRSPlus/prsp.sh');
								kbook.bookData.setData(null);
								Core.ui.showMsg(LA("MSG_RESTART_AUTO"));  
								model.doDeviceShutdown();
							}
						},
						{
							name: "SystemFont3",
							title: LA("ACTION_SYSTEM_FONT_3"),
							group: "SYSTEM_FONTS",
							icon: "FONT",
							action: function () 
							{
								Core.shell.exec('cp -f /Data/fonts/SysFont3/prsp.sh /Data/database/system/PRSPlus/prsp.sh');
								kbook.bookData.setData(null);
								Core.ui.showMsg(LA("MSG_RESTART_AUTO"));  
								model.doDeviceShutdown();
							}
						},
						
						{
							name: "SystemFont4",
							title: LA("ACTION_SYSTEM_FONT_4"),
							group: "SYSTEM_FONTS",
							icon: "FONT",
							action: function () 
							{
								Core.shell.exec('cp -f /Data/fonts/SysFont3/prsp.sh /Data/database/system/PRSPlus/prsp.sh');
								kbook.bookData.setData(null);
								Core.ui.showMsg(LA("MSG_RESTART_AUTO"));  
								model.doDeviceShutdown();
							}
						},
						
						{
							name: "SystemFontSony",
							title: LA("ACTION_SYSTEM_FONT_SONY"),
							group: "SYSTEM_FONTS",
							icon: "FONT",
							action: function () 
							{
								Core.shell.exec('cp -f /Data/fonts/SysFont0/prsp.sh /Data/database/system/PRSPlus/prsp.sh');
								kbook.bookData.setData(null);
								Core.ui.showMsg(LA("MSG_RESTART_AUTO"));  
								model.doDeviceShutdown();
							}
						},
						//Activates/deactivates logging
						{
							name: "ActivateLog",
							title: LA("ACTIVATE_LOG"),
							group: "PRS_DEVELOPER_TOOLS",
							icon: "LOG",
							action: function () 
							{
								Core.shell.exec('cp -f /Data/database/system/PRSPlus/UserConfig/userLog.config /Data/Beta/user.config');
								Core.ui.showMsg(LA("MSG_LOG_ACTIVATE")); 
							}
						},
						
						{
							name: "DeactivateLog",
							title: LA("DEACTIVATE_LOG"),
							group: "PRS_DEVELOPER_TOOLS",
							icon: "LOG",
							action: function () 
							{
								Core.shell.exec('rm -f /DataBeta/user.config');
								Core.shell.exec('rm -f /Data/Books/ErrorLog.txt');
								Core.ui.showMsg(LA("MSG_LOG_DEACTIVATE"));
							}
						},
						//Activates beta-version in /Beta folder. Deactivating with deactivation logging
						{
							name: "ActivateBeta",
							title: LA("ACTIVATE_BETA"),
							group: "PRS_DEVELOPER_TOOLS",
							icon: "INTERNAL_MEM",
							action: function () 
							{
								Core.shell.exec('cp -f /Data/database/system/PRSPlus/UserConfig/userB.config /Data/Beta/user.config');
								Core.ui.showMsg(LA("MSG_BETA_ACTIVATE"));
							}
						},
						/*
						{
							name: "DeactivateBeta",
							title: LA("DEACTIVATE_BETA"),
							group: "PRS_DEVELOPER_TOOLS",
							icon: "BACK",
							action: function () 
							{
								Core.shell.exec('cp -f /Data/database/system/PRSPlus/UserConfig/userNolog.config /Data/Beta/user.config');
								Core.ui.showMsg(LA("MSG_BETA_DEACTIVATE"));
							}
						},
						*/
						
						//Dirty auto-reboot. Works when at least one book has been opened on an updated system:
						{
							name: "RestartReader",
							title: LA("RESTART_READER"),
							group: "PRS_DEVELOPER_TOOLS",
							icon: "BACK",
							action: function () 
							{
								Core.ui.showMsg(LA("MSG_RESTART_AUTO")); 
								kbook.bookData.setData(null);
								model.doDeviceShutdown();								
							}
						},
						//Analogus: End

			{
				name: 'actionLauncher',
				title: LA('ACTION_LAUNCHER'),
				group: 'Utils',
				icon: 'LAUNCHER',
				action: function () {
					model.currentNode.gotoNode(Core.ui.nodes.StandardActions, model);
				}
			},
			{
				name: "Shutdown",
				title: L("ACTION_SHUTDOWN"),
				group: "Other",
				icon: "SHUTDOWN",
				action: function () {
					model.doDeviceShutdown();
				}
			},
			{
				name: "NextPage",
				title: L("ACTION_NEXT_PAGE"),
				group: "Book",
				icon: "NEXT_PAGE",
				bubble: "doNext",
				action: doBubbleFunc				
			},
			{
				name: "PreviousPage",
				title: L("ACTION_PREVIOUS_PAGE"),
				group: "Book",
				icon: "PREVIOUS_PAGE",
				bubble: "doPrevious",
				action: doBubbleFunc
			},
			{
				name: "NextInHistory",
				title: L("ACTION_NEXT_IN_HISTORY"),
				group: "Book",
				icon: "NEXT",
				action: function () {
					if (isBookEnabled()) {
						doHistory(-1);
					}
				}
			},
			{
				name: "PreviousInHistory",
				title: L("ACTION_PREVIOUS_IN_HISTORY"),
				group: "Book",
				icon: "PREVIOUS",
				action: function () {
					if (isBookEnabled()) {
						doHistory(1);
					}
				}
			},
			{
				name: "ContinueReading",
				title: L("ACTION_CONTINUE_READING"),
				group: "Book",
				icon: "CONTINUE",
				action: function () {
					// Show current book
					model.onEnterContinue();
				}
			},
			{
				name: "Standby",
				title: L("ACTION_STANDBY"),
				group: "Other",
				icon: "STANDBY",
				bubble: "doPowerSwitch",
				action: doBubbleFunc
			},
			/*{
				name: "NoAction",
				title: L("ACTION_NO_ACTION"),
				group: "Other",
				icon: "EMPTY",
				action:  function () {
					model.doBlink();
				}
			},*/
			{
				name: "GotoMoreNode",
				title: L("ACTION_MORE_NODE"),
				group: "Other",
				icon: "ROOT_MENU",
				action: function () {
					model.currentNode.gotoNode(Core.ui.nodes.more, model);
				}
			},
			{
				name: "GotoPicturesNode",
				title: L("ACTION_PICTURES_NODE"),
				group: "Other",
				icon: "PICTURE_ALT",
				action: function () {
					var node = kbook.pictures ? kbook.pictures : kbook.root.getPicturesNode();
					model.currentNode.gotoNode(node, model);
				}
			},
			{
				name: "GotoCollectionsNode",
				title: L("ACTION_COLLECTIONS_NODE"),
				group: "Other",
				icon: "COLLECTION",
				action: function () {
					model.currentNode.gotoNode(Core.ui.nodes.collections, model);
				}
			},
			{
				name: "GotoNotesNode",
				title: L("ACTION_NOTES_NODE"),
				group: "Other",
				icon: "TEXT_MEMO",
				action: function () {
					var node = kbook.notepadsText ? kbook.notepadsText : kbook.root.getNotepadsTextNode();
					model.currentNode.gotoNode(node, model);
				}
			},
			{
				name: "GotoFreehandNode",
				title: L("ACTION_FREEHAND_NODE"),
				group: "Other",
				icon: "HANDWRITING_ALT",
				action: function () {
					var node = kbook.notepadsFreehand ? kbook.notepadsFreehand : kbook.root.getNotepadsFreehandNode();
					model.currentNode.gotoNode(node, model);
				}
			},
			{
				name: "DeleteCurrentItem",
				title: L("ACTION_DELETE_CURRENT_ITEM"),
				group: "Utils",
				icon: "CROSSED_BOX",
				action: function () {
					var node, dialog, message, current;
					try {
						node = model.currentNode;
						current = false;
						if (node) {
							dialog = model.getConfirmationDialog();
							dialog.target = model;
							if (model.closeContentsList) {
								message = 'fskin:/l/strings/STR_UI_MESSAGE_DELETE_MANUALLY_NORMAL'.idToString();
							} else {
								// 600
								message = 'fskin:/l/strings/DIALOGMSG_CONFIRM_OPT_DELETE_ALLMYNOTES2'.idToString();
							}
							dialog.onNo = function () { };
							if (model.STATE === 'PAGE') {
								current = true;
								if (!model.closeContentsList) {
									// 600
									message = 'fskin:/l/strings/STR_UI_MESSAGE_DELETEBOOK'.idToString();
								}
								dialog.onOk = function () {
									var node;
									if (model.closeContentsList) {
										node = model.currentNode;
										model.doDeleteBook(true, node);
										kbook.root.update(model);
										model.closeContentsList(true);
									} else {
										// 600
										model.doDeleteBook();
									}
								}
							} else if (model.STATE === 'SONG') {
								current = true;
								dialog.onOk = function () {
									var node = model.currentNode;
									if (model.removeSong) {
										model.removeSong(node);
										kbook.root.update(model);
										if (node.equal(model.currentNode)) {
											model.closeContentsList(true);
										} else {
											model.currentNode.gotoNode(albumList, model);
										}
									} else {
										// 600
										model.onRemove(node);
									}
								}
							} else if (model.STATE === 'PICTURE') {
								current = true;
								if (kbook.standbyPicture.isExist(node)) {
									message = 'fskin:/l/strings/STR_UI_MESSAGE_DELETE_MANUALLY_SELECTED_AS_STANDBY'.idToString();
								}
								dialog.onOk = function () {
									var node, media, source;
									node = model.currentNode;
									if (model.removePicture) {
										model.removePicture(node);
										kbook.root.update(model);
										model.closeContentsList(true);
									} else {
										// 600
										media = node.media;
										source = media.source;
										source.deleteRecord(media.id);
										FileSystem.deleteFile(media.source.path + media.path);
										kbook.root.update(model);
									}
								}
							}
							if (current) {
								dialog.openDialog(message, 0);
							} else {
								Core.ui.doBlink();
							}
						}
					} catch(e) {
						log.error("Error in StandardActions_x50 trying to delete current item", e);
					}
				}
			},
			{
				name: "OpenTOC",
				title: L("ACTION_OPEN_TOC"),
				group: "Book",
				icon: "LIST",
				action: function() {
					var toc = kbook.bookOptionRoot.contents;
					if (toc) {
						model.gotoBookOptionList(toc);
					} else {
						model.doBlink();
					}
				}
			},
			{
				name: "OpenNotes",
				title: L("ACTION_OPEN_NOTES_LIST"),
				group: "Book",
				icon: "NOTES",
				action: function() {
					var notes = kbook.bookOptionRoot.notes;
					if (notes) {
						model.gotoBookOptionList(notes);
					} else {
						model.doBlink();
					}
				}
			},
			{
				name: "ToggleNotesToolbar",
				title: L("ACTION_TOGGLE_NOTES_TOOLBAR"),
				group: "Book",
				icon: "NOTES",
				action: function() {
					pageOptionToolbarOverlayModel.onOptionToolbar();
				}
			},
			{
				name: "ZoomPage",
				title: L("ACTION_ZOOM_PAGE"),
				group: "Book",
				icon: "SEARCH_ALT",
				action: function() {
				   pageSizeOverlayModel.openCurrentOverlay();
				   pageSizeOverlayModel.goZoomMode();
				}
			}
		]
	};

	// Optional actions depending on the model
	try {
		addBubbleActions(StandardActions.actions);
		addOptionalActions(StandardActions.actions);
	} catch (e) {
		log.trace("Failed to add optional/bubble actions " + e);
	}
	
	Core.addAddon(StandardActions);
};
try {
	tmp();
} catch (e) {
	// Core's log
	log.error("in StandardActions.js", e);
}